-- 26.12.20/AH Qualitywings AVRO RJ
-- Params:
--  1+ 2 : Battery on/off
--  3+ 4 : Standby Inverter and Generator on/off
--  5+ 6 : Flight Deck Emergency Lights arm/off
--  7+ 8 :Nav Lights on/off
--  9+10 : Beacon Lights on/off
-- 11+12 : Strobe Lights on/off
-- 13+14 : Taxi/Landing Lights switch 13=taxi/ldg, 14=off
-- 15+16 : Switch btw. Taxi and Landing Lights position
-- 17+18 : Flight Deck Entry lights on/off
-- 19+20 : Wing lights on/off
-- 21+22 : Logo lights on/off
-- 23+24 : Instrumentenbeleuchtung
-- 25+26 : Runway Exit Lights

--
-- 1 + 2 : Battery (T&T) on/off
--
if ipcPARAM == 1 then
-- Battery on
  if ipc.readLvar("elec_batt_switch") == 0 then
    ipc.writeLvar("elec_batt_switch_clicked", 1)
  end
  return
elseif ipcPARAM == 2 then
-- Battery off
  if ipc.readLvar("elec_batt_switch") == 1 then
    ipc.writeLvar("elec_batt_switch_clicked", 1)
  end
  return
--
-- 3 + 4 : Standby Inverter & Stdby Generator (T&T) on/off
--
elseif ipcPARAM == 3 then
-- Standby inverter on 
  if ipc.readLvar("elec_stby_inv_switch") == 0 then
    ipc.writeLvar("elec_stby_inv_switch_clicked", 1)
  end
  ipc.sleep(250) 
-- Standby generator on 
  if ipc.readLvar("elec_stby_gen_switch") == 0 then
    ipc.writeLvar("elec_stby_gen_switch_clicked", 1)
  end
  return
elseif ipcPARAM == 4 then
-- Standby inverter off
  if ipc.readLvar("elec_stby_inv_switch") == 1 then
    ipc.writeLvar("elec_stby_inv_switch_clicked", 1)
  end	
  ipc.sleep(250) 
-- Standby generator off
  if ipc.readLvar("elec_stby_gen_switch") == 1 then
    ipc.writeLvar("elec_stby_gen_switch_clicked", 1)
  end
  return
--
-- 5 + 6 : Flight Deck emergency lights arm/off (not on, only one click !)
-- Position 0=Off, 1=On, 2=ARM, d.h. je nach Stellung evtl. zweimal klicken notwendig
--
elseif ipcPARAM == 5 then
-- Flt Deck emer lights ARM
  if ipc.readLvar("flt_deck_emerg_lts_switch") == 1 then
    ipc.writeLvar("flt_deck_emerg_lts_switch_clicked", 1)
  elseif ipc.readLvar("flt_deck_emerg_lts_switch") == 0 then
    ipc.writeLvar("flt_deck_emerg_lts_switch_clicked", 2)
  end
  return
elseif ipcPARAM == 6 then
-- Flt Deck emer lights off
  if ipc.readLvar("flt_deck_emerg_lts_switch") == 2 then
    ipc.writeLvar("flt_deck_emerg_lts_switch_clicked", 1)
  elseif ipc.readLvar("flt_deck_emerg_lts_switch") == 1 then
    ipc.writeLvar("flt_deck_emerg_lts_switch_clicked", 1)
    ipc.sleep(250)
    ipc.writeLvar("flt_deck_emerg_lts_switch_clicked", 1)
  end
  return
--
-- 7 + 8 : Nav Lights on/off
--  
elseif ipcPARAM == 7 then
-- Nav Lights on
  if ipc.readLvar("nav_lights_switch") == 0 then
    ipc.writeLvar("nav_lights_switch_clicked", 1)
  end
  return
elseif ipcPARAM == 8 then
-- Nav Lights off
  if ipc.readLvar("nav_lights_switch") == 1 then
    ipc.writeLvar("nav_lights_switch_clicked", 1)
  end
  return
--
-- 9+10 : Beacon Lights on/off
--  
elseif ipcPARAM == 9 then
-- Beacon Lights on
    if ipc.readLvar("beacon_lights_switch") == 0 then
    ipc.writeLvar("beacon_lights_switch_clicked", 1)
    end
  return
elseif ipcPARAM == 10 then
-- Beacon Lights off
  if ipc.readLvar("beacon_lights_switch") == 1 then
    ipc.writeLvar("beacon_lights_switch_clicked", 1)
  end
  return
--
-- 11+12 : Strobe Lights on/off
--  
elseif ipcPARAM == 11 then
-- Strobe Lights on
  if ipc.readLvar("strobe_lights_switch") == 0 then
    ipc.writeLvar("strobe_lights_switch_clicked", 1)
  end
  return
elseif ipcPARAM == 12 then
  if ipc.readLvar("strobe_lights_switch") == 1 then
    ipc.writeLvar("strobe_lights_switch_clicked", 1)
  end
  return
--
-- 13+14 : Taxi/Landing Lights switch 13=taxi/ldg, 14=off
-- Position 0=Off, 1=Enable Taxi/Landing
-- Taxi oder Landing hängt dann von 15+16 ab
-- Benutzt FSX User Area 0x66C0 (Enab/Disab) und 0x66C1 (former state)
-- LVAR:taxi_landing_lights_switch : Status 0=Taxi, 2=off, 1=Landing Lt. (Switch: 0-2-1)
-- LVAR:taxi_landing_lights_switch_clicked : Action 1=click down, 2=click up
--
-- Switch Taxi/Landing Lt on depending on former position
elseif ipcPARAM == 13 then 
 
  TxLdState=ipc.readUB(0x66C1)				-- Read "Former Position" in FSX User Area
  TxLdActSt=ipc.readLvar("taxi_landing_lights_switch")	-- Read "Actual Position" from Aircraft
-- Former state Landing Lt. (1) ?
  if  TxLdState == 1 then
-- Actual state Taxi Lights (0) of Off (2) ?  
    if (TxLdActSt == 0) or (TxLdActSt == 2) then
      ipc.writeLvar("taxi_landing_lights_switch_clicked", 2)	--  click one up
-- Actual state Taxi (0) ?	  
      if TxLdActSt == 0 then
        ipc.sleep(250)
        ipc.writeLvar("taxi_landing_lights_switch_clicked", 2)	--  click one more up
      end
    end 
-- Otherwise set state Taxi Lt (0)
  else
-- Actual state Landing Lts (1) or Off (2) ?  
    if (TxLdActSt == 1) or (TxLdActSt == 2) then
      ipc.writeLvar("taxi_landing_lights_switch_clicked", 1)	----  click one down
-- Actual state  Landing Lights (1) ?  
      if TxLdActSt == 1 then
	    ipc.sleep(250)
        ipc.writeLvar("taxi_landing_lights_switch_clicked", 1)	----  click one more down
      end
    end
  end
-- Write "Enable Taxi/Ldg" to FSX User Area  
  ipc.writeUB(0x66C0,1)				

  return
-- Switch Taxi/Landing Lt off
elseif ipcPARAM == 14 then
  
  TxLdActSt=ipc.readLvar("taxi_landing_lights_switch")		-- Read "Actual Position" from Aircraft
-- Actual state Taxi (2) or Landing Lights (1) ?  
  if (TxLdActSt == 0) then
    ipc.writeLvar("taxi_landing_lights_switch_clicked", 2)	--  click one up
-- Actual state Landing Lights (1) ?  
  elseif (TxLdActSt == 1) then
    ipc.writeLvar("taxi_landing_lights_switch_clicked", 1)	--  click one down
  end
-- Write "Disable Taxi/Ldg" to FSX User Area
  ipc.writeUB(0x66C0,0)
  return

--  
-- 15+16 : Switch btw. Taxi and Landing Lights position
--  
-- Switch position Landing Lt
elseif ipcPARAM == 15 then 

  TxLdState=1											-- Set "Former Position" to Landing Light
  ipc.writeUB(0x66C1,TxLdState)							-- Set "Former Position" in FSX User Area
  TxLdEnab=ipc.readUB(0x66C0)							-- Read "Taxi/Landing Enab" from FSX User Area
  TxLdActSt=ipc.readLvar("taxi_landing_lights_switch")	-- Read "Actual Position" from Aircraft
  
-- If Taxi/Landing disabled, switch off
  if TxLdEnab == 0 then
 -- Actual state Taxi (0) ?
    if (TxLdActSt == 0) then
      ipc.writeLvar("taxi_landing_lights_switch_clicked", 2)	--  click one up
 -- Actual state Landing (1) ?
    elseif (TxLdActSt == 1) then
      ipc.writeLvar("taxi_landing_lights_switch_clicked", 1)	--  click one down
    end 	  
-- If Taxi/Landing enabled, switch on Landing Light
  else
-- Actual state Taxi (0) or Off (2) ?  
    if (TxLdActSt == 0) or (TxLdActSt == 2) then
      ipc.writeLvar("taxi_landing_lights_switch_clicked", 2)	--  click one up
-- Actual state Taxi (0) ?	  
      if TxLdActSt == 0 then
        ipc.sleep(250)
        ipc.writeLvar("taxi_landing_lights_switch_clicked", 2)	--  click one more up
      end
    end
  end	
  return

-- Switch position Taxi Lt
elseif ipcPARAM == 16 then 

  TxLdState=0											-- Set "Former Position" to Taxi Light
  ipc.writeUB(0x66C1,TxLdState)							-- Set "Former Position" in FSX User Area
  TxLdEnab=ipc.readUB(0x66C0)							-- Read "Taxi/Landing Enab" from FSX User Area
  TxLdActSt=ipc.readLvar("taxi_landing_lights_switch")	-- Read "Actual Position" from Aircraft
  
-- If Taxi/Landing disabled, switch off
  if TxLdEnab == 0 then
 -- Actual state Taxi (0) ?
    if (TxLdActSt == 0) then
      ipc.writeLvar("taxi_landing_lights_switch_clicked", 2)	--  click one up
 -- Actual state Landing (1) ?
    elseif (TxLdActSt == 1) then
      ipc.writeLvar("taxi_landing_lights_switch_clicked", 1)	--  click one down
    end 	  
  else 
 -- Actual state Landing Lights (1) or Off (2) ?  
    if (TxLdActSt == 1) or (TxLdActSt == 2) then
      ipc.writeLvar("taxi_landing_lights_switch_clicked", 1)	--  click one down
-- Actual state Landing Lights (1) ?	  
      if TxLdActSt == 1 then
        ipc.sleep(250)
        ipc.writeLvar("taxi_landing_lights_switch_clicked", 1)	--  click one more down
      end
    end
  end
  return

--
-- 17+18 : Flight Deck Entry lights on/off
--
elseif ipcPARAM == 17 then
  if ipc.readLvar("entry_light_switch") == 0 then
    ipc.writeLvar("entry_light_switch_clicked", 1)
  end
  return
  
elseif ipcPARAM == 18 then
  if ipc.readLvar("entry_light_switch") == 1 then
    ipc.writeLvar("entry_light_switch_clicked", 1)
  end
  return

--
-- 19+20 : Wing lights on/off
--
elseif ipcPARAM == 19 then
  if ipc.readLvar("wing_lights_switch") == 0 then
    ipc.writeLvar("wing_lights_switch_clicked", 1)
  end
  return
  
elseif ipcPARAM == 20 then
  if ipc.readLvar("wing_lights_switch") == 1 then
    ipc.writeLvar("wing_lights_switch_clicked", 1)
  end
  return

--
-- 21+22 : Logo lights on/off
--
elseif ipcPARAM == 21 then
  if ipc.readLvar("logo_lights_switch") == 0 then
    ipc.writeLvar("logo_lights_switch_clicked", 1)
  end
  return
elseif ipcPARAM == 22 then
  if ipc.readLvar("logo_lights_switch") == 1 then
    ipc.writeLvar("logo_lights_switch_clicked", 1)
  end
  return

--
-- 23+24 : Instrumentenbeleuchtung
--
elseif ipcPARAM == 23 then

  if ipc.readLvar("QW_GS_Lit_Text") == 0 then
    ipc.writeLvar("QW_GS_Lit_Text_clicked", 1)
  end
  ipc.sleep(500)

  if ipc.readLvar("QW_OH_Lit_Text") == 0 then
    ipc.writeLvar("QW_OH_Lit_Text_clicked", 1)
  end
  ipc.sleep(500)

  if ipc.readLvar("QW_Lit_Text") == 0 then
    ipc.writeLvar("QW_Lit_Text_clicked", 1)
  end
  ipc.sleep(500)

  if ipc.readLvar("QW_FwdConsole_Lit_Text") == 0 then
    ipc.writeLvar("QW_FwdConsole_Lit_Text_clicked", 1)
  end
  ipc.sleep(500)

  if ipc.readLvar("QW_AftConsole_Lit_Text") == 0 then
    ipc.writeLvar("QW_AftConsole_Lit_Text_clicked", 1)
  end

elseif ipcPARAM == 24 then

  if ipc.readLvar("QW_AftConsole_Lit_Text") == 1 then
    ipc.writeLvar("QW_AftConsole_Lit_Text_clicked", 1)
  end
  ipc.sleep(500)

  if ipc.readLvar("QW_FwdConsole_Lit_Text") == 1 then
    ipc.writeLvar("QW_FwdConsole_Lit_Text_clicked", 1)
  end
  ipc.sleep(500)

  if ipc.readLvar("QW_Lit_Text") == 1 then
    ipc.writeLvar("QW_Lit_Text_clicked", 1)
  end
  ipc.sleep(500)

  if ipc.readLvar("QW_OH_Lit_Text") == 1 then
    ipc.writeLvar("QW_OH_Lit_Text_clicked", 1)
  end
  ipc.sleep(500)

  if ipc.readLvar("QW_GS_Lit_Text") == 1 then
    ipc.writeLvar("QW_GS_Lit_Text_clicked", 1)
  end

--
-- 25+26 : Runway Exit Lights
--
elseif ipcPARAM == 25 then
  if ipc.readLvar("QW_Light_RwyTurnOff") == 0 then
    ipc.writeLvar("QW_Light_RwyTurnOff_clicked", 1)
  end
elseif ipcPARAM == 26 then
  if ipc.readLvar("QW_Light_RwyTurnOff") == 1 then
    ipc.writeLvar("QW_Light_RwyTurnOff_clicked", 1)
  end

---
--- ipcPARAM unknown/not handled
---  
else
  -- Message in Sim
  ipc.display("QW_Avro_RJ_Switch: Unhandled Parameter " .. ipcPARAM)
  ipc.sleep(2000)     
end
